//	DosCatalog.c

#include "string.h"
#include "DebugStuff.h"
#include "IC_Errors.h"
#include "DosCatalog.h"

void	Dos_SetFileName(Dos_DirEntry *entryP, char *buf)
{
	short	index;
	size_t	bufLen = strlen(buf);
	char	theChar;
	
	if (bufLen > Dos_kNameLength) {
		bufLen = Dos_kNameLength;
	}
	
	for (index = 0; index < Dos_kNameLength; index++) {
		
		if (index < bufLen) {
			theChar = buf[index];
			
			//	filter illegal characters
			if (
				theChar == ','
				|| (index == 0 && (theChar >= 0 && theChar <= 9))
			) {
				theChar = '.';
			}
		} else {
			theChar = ' ';
		}

		entryP->name[index] = theChar | 0x80;
	}
}

char	*Dos_GetFileName(Dos_DirEntry *entryP, char *buf)
{
	short			index;
	char			theChar;
	
	for (index = 0; index < Dos_kNameLength; index++) {
		theChar = entryP->name[index] & 0x7F;
		
		//	filter control characters
		if (theChar >= 0 && theChar < ' ') {
			theChar = '.';
		}
		
		buf[index] = theChar;
	}
	
	if (Dos_IsDeleted(entryP)) {
		buf[Dos_kNameLength - 1] = ' ';
	}

	buf[Dos_kNameLength] = 0;
	
	//	remove trailing spaces
	for (index = Dos_kNameLength - 1; index > 0; index--) {
		if (buf[index] != ' ') {
			index = 0;
		} else {
			buf[index] = 0;
		}
	}
	
	return buf;
}

static	char	*Dos_GetFileType(Dos_FileType type, char *buf)
{
	buf[2] = 0;
	buf[0] = type & Dos_FileType_LOCK ? '*' : ' ';
	
	switch (type & Dos_FileType_MASK) {
		case Dos_FileType_TXT:	buf[1] = 'T';	break;
		case Dos_FileType_INT:	buf[1] = 'I';	break;
		case Dos_FileType_BAS:	buf[1] = 'A';	break;
		case Dos_FileType_BIN:	buf[1] = 'B';	break;
		case Dos_FileType_S:	buf[1] = 'S';	break;
		case Dos_FileType_R:	buf[1] = 'R';	break;
		case Dos_FileType_a:	buf[1] = 'a';	break;
		case Dos_FileType_b:	buf[1] = 'b';	break;
	}
	
	return buf;
}
/*

void	Dos_Catalog(DiskImageRec *imageRec)
{
	Dos_VtocSector	vtoc;
	Dos_VtocSector	*vtocP = &vtoc;
	
	if (Dos_GetSector(imageRec, Dos_gVtocSector, &vtocP) == noErr) {
		Dos_DirSector	*dirRec;
		short			entryCount;
		Boolean			done = FALSE;

		printf("\nDOS 3.3 Volume %d\n\n", (short)vtocP->volumeNumber);

		for (
			dirRec = (Dos_DirSector *)Dos_GetSector(imageRec, vtocP->dirSector);
			!done;
			dirRec = (Dos_DirSector *)Dos_GetSector(imageRec, dirRec->nextDirSector)
		) {
			done = Dos_IsNullSector(dirRec->nextDirSector);
					
			for (entryCount = 0; entryCount < Dos_kMaxEntriesPerSector; entryCount++) {
				Dos_DirEntry	*entry = &dirRec->entry[entryCount];
				
				if (Dos_IsDeleted(entry) && !Dos_IsNullSector(entry->firstTSSector)) {
					Dos_FileNameStr		nameStr;
					char				fileTypeStr[3];				
					
					printf(
						"%s %03d %s\n", 
						Dos_GetFileType(entry->fileType, fileTypeStr), 
						(short)entry->size.low, 
						Dos_GetFileName(entry, nameStr)
					);
				}
			}
		}
		
		printf("\n");
	}
}


void	BuildDir(ADFS_FinderItem *disk)
{
	SectorSpec	sSpec = { 0x11, 0x00 };
	VTOC		*vtoc = (VTOC *)GetSector(disk->image, sSpec);
	DirRec		*dirRec;
	short		entryCount, 		//	local per sector
				dirIndex = 0;		//	total over all
	Boolean		done = FALSE;
	
	for (
		dirRec = (DirRec *)GetSector(disk->image, vtoc->dirSector);
		!done;
		dirRec = (DirRec *)GetSector(disk->image, dirRec->nextDirSector)
	) {
		done = NullSector(dirRec->nextDirSector);
		
		for (entryCount = 0; entryCount <= 6; entryCount++) {
			DirEntry		*entry	= &dirRec->entry[entryCount];
			SectorSpec		tsList	= entry->tsList;
			
			if (!NullSector(tsList)) {
				DirectoryEntry	*fEntry = &disk->dir[dirIndex];
				short			ind;
				
				//	get Name
				fEntry->name[kNameLength] = 0;
				for (ind = 0; ind < kNameLength; ind++) {
					fEntry->name[ind] = entry->name[ind] & 0x7F;
				}
				
				//	adjust Name and TSList if file is Deleted
				//	also mark entry as inTrash
				if (entry->tsList.track == 0xFF) {					//	if deleted
					tsList.track = fEntry->name[kNameLength - 1];	//	reconstruct TSList
					fEntry->name[kNameLength - 1] = 0;				//	name is 1 char shorter
					fEntry->inTrash = TRUE;							//	we are in the trash
				}
				
				//	kill trailing spaces

				//	get Locked state
				fEntry->locked = (entry->fileType & 0x80) != 0;
				
				//	get file type
				fEntry->type = entry->fileType;
				
				//	get file size
				fEntry->size = GetRboShort(entry->size);
				
				//	get file load address and length (BIN and BAS only)
				if (entry->fileType & 0x02)	{	//	we are BAS
					FileSector_BASIC	*basRec = 
						(FileSector_BASIC *)GetSector(disk->image, tsList);
					
					fEntry->length = GetRboShort(basRec->length);
				} else if (entry->fileType & 0x04)	{	//	we are BIN
					FileSector_BIN		*binRec = 
						(FileSector_BIN *)GetSector(disk->image, tsList);
					
					fEntry->loadAddress	= GetRboShort(binRec->loadAddress);
					fEntry->length		= GetRboShort(binRec->length);
				}
				
				dirIndex++;
			}
		}
	}
}
*/